# Package Manager

This component have task to fetch dependencies defined in [`Project/Sources/dependencies.json`](https://developer.4d.com/docs/Project/components/#dependenciesjson) defined by database.

The main method is [_Fetch_dependencies](Project/Sources/Methods/_Fetch_dependencies.4dm), launched if there is someting to fetch.

## GitHub

The first dependency that could be fetched are attached archive to GitHub release.

### Definition of a GitHub dependency

In `dependencies.json` it could be defined as follow 

```json
{
  "dependencies": {
    "SampleTestProject": { "github": "e-marchand/SampleTestProject" }
  }
}
```

Here we defined a dependency `SampleTestProject` for GitHub project [e-marchand/SampleTestProject](https://github.com/e-marchand/SampleTestProject/)

Because we do defined any tag or semantic version, it will download the [latest release asset](https://github.com/e-marchand/SampleTestProject/releases/tag/9.0.0) named `SampleTestProject.zip` (same name as dependency)

#### Selecting a version or tag

You could add a tag like [4.0.0](https://github.com/e-marchand/SampleTestProject/releases/tag/4.0.0) to download specific version.

```json
"SampleTestProject": { "github": "e-marchand/SampleTestProject", "tag": "4.0.0" }
```

You could also use a pattern that follow [Semantic versioning](https://semver.org) to select a version.
For instance `3.*` will select the [3.4.5](https://github.com/e-marchand/SampleTestProject/releases/tag/3.4.5) release.

```json
"SampleTestProject": { "github": "e-marchand/SampleTestProject", "version": "3.*" }
```

### Content of the release archive

The archive must be a valid project
- a builded project with the `.4DZ`
- a source project with a `.4dproject` file in `Project/`

### Where are downloaded dependencies

The archive are unzipped in a subdirectory `PackageManager/.github/` of the OS cache folder for curent app.
- for instance on macOS `$HOME/Library/Caches/4D/PackageManager/.github`
